<?php
/*

*/

//runtime
$startTime = time();

echo("\n\nWelcome to Tiiveni's BBC iPlayer .ts downloader...");

//get url from input
$inputURL = $argv[1];
//echo arg URL for debugging
echo("\n\nInput URL: ".($inputURL));

//get search string from input
//$searchString = $argv[2];
//get search string from Settings.ini
$searchString = file_get_contents('./files/Settings.ini', true);;

//echo arg Search String for debugging
echo("\n\nSearch String: ".($searchString));

echo("\n\nCalculating...");

//find vPID from input URL
$vPID = getvPID($inputURL);
//echo vPID for debugging
echo("\n\nvPID: ".($vPID));

//open connection using MediaSelector
$mediaSelectorURL = "http://open.live.bbc.co.uk/mediaselector/5/select/version/2.0/mediaset/pc/vpid/";
$mediaSelectorURL = $mediaSelectorURL.$vPID;
echo("\n\nMediaSelector URL: ".($mediaSelectorURL));
for ($retries=0; $retries <=10; $retries++) {
	$url = openMediaSelector($mediaSelectorURL);
	echo("Retry".$retries);
	if ($url != "No URLs were found!") {
		$retries = 10;
	}
}
echo("\n\nDiscovered URL: ".($url));

//find root of discovered URL
$rootUrl = str_replace(strrchr($url,"/"),"",$url)."/";
//echo root of discovered URL for debugging
echo("\n\nRoot of discovered URL: ".($rootUrl));

//find MasterKey - stores all keys for downloads and used as a marker in the strings
$masterKey = str_replace($rootUrl,"",$url);
$masterKey = strstr($masterKey,".",true);
//echo Master Key for debugging
echo("\n\nMaster Key: ".($masterKey));

//create the m3u8 url from the discovered url and the Master Key
$url = $url."/".$masterKey.".m3u8";
echo("\n\nFull M3u8 URL: ".($url));

//find root of m3u8 URL
$rootUrl = str_replace(strrchr($url,"/"),"",$url)."/";
//echo root of URL for debugging
echo("\n\nRoot of m3u8 URL: ".($rootUrl));

//get stream with correct bandwith
$streamUrl = getHighBandwidthStream($url,$searchString);
$streamUrl = $rootUrl.$streamUrl;
//echo stream URL for debugging
echo("\n\nStream URL: ".($streamUrl));

if($searchString=="") exit("\n\nPlease add chosen '-audio_1=' and '-video=' to the Settings.ini file and run the code again to download.");

//find MasterKey - stores all keys for downloads and used as a marker in the strings
$masterKey = str_replace($rootUrl,"",$streamUrl);
$masterKey = strstr($masterKey,".",true);
//echo Master Key for debugging
echo("\n\nm3u8 Master Key: ".($masterKey));

//get array of all links to *.ts files
$list = getHlsFiles($streamUrl,$masterKey);

//make new directory
if (!is_dir('downloads')) {
	//mkdir('downloads');
	shell_exec("MD downloads");
}

$n = 1;
foreach ($list as $key) {
	for ($retries=0; $retries <=10; $retries++) {
		echo("\nRetry: ".$retries.". ");
		echo("Downloading ".$n." out of ".count($list).".");
		$success=downloadHlsFiles($rootUrl,$key);
		if ($success == true) {
			$retries = 10;
		}
	}
	$n ++;
}

//make new directory
if (!is_dir('files')) {
	//mkdir('files');
	shell_exec("MD files");
}

//Find full program title from BBC from the PID
$programPID = explode("_",$masterKey);
$programPID = $programPID[1];
//echo Master Key for debugging
echo("\n\nProgram PID: ".($programPID));

$programTitle = downloadProgramTitle($programPID);
//echo Program Title for debugging
echo("\n\nProgram Title: ".($programTitle));

//merge files
$opHandle = fopen("files\\".$programTitle.".ts", 'a');
$n = 1;
echo("\n");
foreach ($list as $key) {
	$number = str_pad($n, 3, "0", STR_PAD_LEFT);
	echo($n." ");
	fwrite($opHandle, file_get_contents("downloads\\".$key, 'r'));
	$n++;
}
fclose($opHandle);

//delete part files
sleep(1);
deleteFiles('files',$programPID,$programTitle);

//echo part numbers and runtime for debugging
echo("\nTime used for download: ".(time()-$startTime)." seconds.");

//input. string, output: string
function getvPID($inputURL) {
	//download iPlayer page and read vPID (no proxy needed)
	$proxy = "127.0.0.1:9050";
	$ch = curl_init($inputURL);
	//curl_setopt($ch, CURLOPT_PROXYTYPE, CURLPROXY_SOCKS5);
	//curl_setopt($ch, CURLOPT_PROXY, $proxy);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_BINARYTRANSFER, true);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	//curl_setopt($ch, CURLOPT_NOBODY, true);
	//curl_setopt($ch, CURLOPT_HEADER, true);
	
	$iplayerPage = curl_exec($ch);
	curl_close($ch);
	//echo ("\n\n".$iplayerPage);

	//search for "vpid":"
	$search_Text = chr(0x22)."vpid".chr(0x22).":".chr(0x22);
	//echo ("\n\nSearch Text: ".$search_Text);
	$iplayerPage = strstr($iplayerPage,$search_Text);
	$iplayerPage = str_replace($search_Text,"",$iplayerPage);
	//echo ("\n\n".$iplayerPage);

	//search for "
	$search_Text = "".chr(0x22);
	//echo ("\n\nSearch Text: ".$search_Text);
	$iplayerPage = strstr($iplayerPage,$search_Text,true);
	$iplayerPage = str_replace($search_Text,"",$iplayerPage);
	//echo ("\n\n".$iplayerPage);

	$vPID_String=trim($iplayerPage);
	//echo ("\n\nvPID: ".$vPID_String);
	return $vPID_String;
}

function openMediaSelector($mediaSelectorURL) {
	//open MediaSelector connection and get links to stream URLs
	$proxy = "127.0.0.1:9050";
	$ch = curl_init($mediaSelectorURL);
	//curl_setopt($ch, CURLOPT_PROXYTYPE, CURLPROXY_SOCKS5);
	//curl_setopt($ch, CURLOPT_PROXY, $proxy);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_BINARYTRANSFER, true);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	$raw_Result = curl_exec($ch);
	curl_close($ch);

	//echo MediaSelector XML for debugging
	//echo("\nMediaSelector XML: ".($raw_Result));

	// explode XML using -> href="
	$xmlArray = explode("href=", $raw_Result, 1023);
	$arrlength = count($xmlArray);
	$bestResult = "No URLs were found!";
	for ($x = 1; $x < $arrlength; $x++) {

		//search for "
		$search_Text = "".chr(0x22);
		//echo ("\n\nSearch Text: ".$search_Text);
		$xmlArray[$x] = strstr($xmlArray[$x],$search_Text);
		//echo ("\n\n".$xmlArray[$x]);

		//search for h as in "http"
		$search_Text = "h";
		//echo ("\n\nSearch Text: ".$search_Text);
		$xmlArray[$x] = strstr($xmlArray[$x],$search_Text);
		//echo ("\n\n".$xmlArray[$x]);

		//search for "
		$search_Text = "".chr(0x22);
		//echo ("\n\nSearch Text: ".$search_Text);
		$xmlArray[$x] = strstr($xmlArray[$x],$search_Text,true);
		//echo ("\n\n".$xmlArray[$x]);

		echo ("\n\nhref ".$x.": ".$xmlArray[$x]);

		if (strpos($xmlArray[$x],".ism/")!=FALSE) {
			$xmlArray[$x] = strstr($xmlArray[$x],".ism/",true);
			$xmlArray[$x] = $xmlArray[$x].".ism";
			$bestResult = $xmlArray[$x];
		}
	}

	if ($bestResult == "No URLs were found!") {
		echo ("\n\nNO URLS WERE FOUND! LOOK...\n".$raw_Result);
	}

	$finalResult=trim($bestResult);
	echo ("\n\nFINAL RESULT: ".$finalResult);
	return $finalResult;
}

//input: string, output: string
function getHighBandwidthStream($masterUrl,$masterSearchString) {
	//get content of master.m3u8
	$proxy = "127.0.0.1:9050";
	$ch = curl_init($masterUrl);
	//curl_setopt($ch, CURLOPT_PROXYTYPE, CURLPROXY_SOCKS5);
	//curl_setopt($ch, CURLOPT_PROXY, $proxy);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_BINARYTRANSFER, true);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	$raw_Result = curl_exec($ch);
	curl_close($ch);

	//echo m3u8 file for debugging
	//echo("\nm3u8 file: ".($raw_Result));
	
	//remove comments and unnecessary data
	$result = explode("#", $raw_Result);

	//extract file links
	$quoteString ='"';
	$options = 0;
	$bestResult= "There was an error!";
	for ($i = 0; $i < count($result); $i++) {
		if(strstr($result[$i], "EXT-X-STREAM-INF:")!=FALSE) {
			if($masterSearchString!="") { 
				if(strstr($result[$i], $masterSearchString)!=FALSE) {
					$result[$i] = str_replace($quoteString,"#",$result[$i]);
					$result[$i] = strrchr($result[$i],"#");
					$result[$i] = str_replace("#","",$result[$i]);
					$options = $options+1;
					if ($options == 1) {
						echo("\n\nFound ".$options.": ".trim($result[$i]));
					} else {
						echo(  "\nFound ".$options.": ".trim($result[$i]));
					}
					$bestResult=$result[$i];
				}
			} else { 
				$result[$i] = str_replace($quoteString,"#",$result[$i]);
				$result[$i] = strrchr($result[$i],"#");
				$result[$i] = str_replace("#","",$result[$i]);
				$options = $options+1;
				if ($options == 1) {
					echo("\n\nFound ".$options.": ".trim($result[$i]));
				} else {
					echo(  "\nFound ".$options.": ".trim($result[$i]));
				}
				$bestResult=$result[$i];
			}
		}
	}

	$finalResult=trim($bestResult);
	echo ("\n\nFINAL RESULT: ".$finalResult);
	return $finalResult;
}

//input: string, output: array
function getHlsFiles($streamUrl,$masterKey) {
	//get content of *.m3u8 file
	$proxy = "127.0.0.1:9050";
	$ch = curl_init($streamUrl);
	//curl_setopt($ch, CURLOPT_PROXYTYPE, CURLPROXY_SOCKS5);
	//curl_setopt($ch, CURLOPT_PROXY, $proxy);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_BINARYTRANSFER, true);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	$raw = curl_exec($ch);
	curl_close($ch);

	//echo($raw);
	//echo("\n\nFiles for Downloading:\n");

	//remove comments and unnecessary data
	$list_raw = explode("#", $raw);
	
	//extract file links
	$list = array();	
	for ($i = 0; $i < count($list_raw); $i++) {
		if(strstr($list_raw[$i], "EXTINF:")!=FALSE) { 
			$list_raw[$i] = strstr($list_raw[$i],$masterKey);
			//$list_raw[$i] = str_replace($masterKey,"",$list_raw[$i]);
			$list_raw[$i] = trim($list_raw[$i]);
			//echo("\n".$list_raw[$i]);
			array_push($list,$list_raw[$i]);
		}
	}
	

	echo("\n\nFound ".count($list)." files for Downloading:\n");

	//return array
	return $list;
}

//input: string, output: true
function downloadHlsFiles($rootUrl,$fileName) {
	$streamUrl = $rootUrl.$fileName;
	//echo("\n".$streamUrl);

	//download all .ts files
	$proxy = "127.0.0.1:9050";
	$ch = curl_init($streamUrl);
	//curl_setopt($ch, CURLOPT_PROXYTYPE, CURLPROXY_SOCKS5);
	//curl_setopt($ch, CURLOPT_PROXY, $proxy);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_BINARYTRANSFER, true);
	$raw_ts_file = curl_exec($ch);
	$success = true;
	if($raw_ts_file == false)
	{
		echo " Curl error: " . curl_error($ch).".";
		$success = false;
	}
	else
	{
		echo " Operation completed without any errors.";
		$success = true;
	}
	curl_close($ch);

	//echo($raw_ts_file);

	$output_filename = "downloads\\".$fileName;
	$output_filename = ($output_filename);
	// the following lines write the contents to a file in the same directory (provided permissions etc)
	$fp = fopen($output_filename, 'w');
	fwrite($fp, $raw_ts_file);
	fclose($fp);

//if(ffprobe -v quiet -show_error -i "$pathname" != null)
//shell_exec("

	return $success;
}


//input: string, output: string
function downloadProgramTitle($programPID) {
	//Download the Title of the program
	$streamUrl = "http://www.bbc.co.uk/iplayer/episode/".$programPID;
	//$streamUrl = "http://www.bbc.co.uk/programmes/".$programPID.".xml";
	echo("\n".$streamUrl."\n");

	//download iPlayer page for the program (no proxy needed)
	$ch = curl_init($streamUrl);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_BINARYTRANSFER, true);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	//curl_setopt($ch, CURLOPT_NOBODY, true);
	//curl_setopt($ch, CURLOPT_HEADER, true);
	
	$iplayerEpisode = curl_exec($ch);
	curl_close($ch);
	//echo ("\n\n".$iplayerEpisode);

	$iplayerEpisode = strstr($iplayerEpisode,"<title>");
	$iplayerEpisode = strstr($iplayerEpisode,"</title>",true);
	$iplayerEpisode = str_replace("<title>","",$iplayerEpisode);
	$iplayerEpisode = str_replace("</title>","",$iplayerEpisode);

	$iplayerEpisode = trim($iplayerEpisode);

	$iplayerEpisode = str_replace(":","",$iplayerEpisode);
	$iplayerEpisode = str_replace("<","",$iplayerEpisode);
	$iplayerEpisode = str_replace(">","",$iplayerEpisode);
	$iplayerEpisode = str_replace("/","",$iplayerEpisode);
	$iplayerEpisode = str_replace("\\","",$iplayerEpisode);
	$iplayerEpisode = str_replace(chr(0x22),"-",$iplayerEpisode);
	$iplayerEpisode = str_replace("*","",$iplayerEpisode);
	$iplayerEpisode = str_replace("?","",$iplayerEpisode);
	$iplayerEpisode = str_replace("|","",$iplayerEpisode);
	/*
	$iplayerEpisode = str_replace(" ","_",$iplayerEpisode);
	$iplayerEpisode = str_replace(",","",$iplayerEpisode);
	$iplayerEpisode = str_replace("!","",$iplayerEpisode);
	$iplayerEpisode = str_replace("#","",$iplayerEpisode);
	$iplayerEpisode = str_replace("$","",$iplayerEpisode);
	$iplayerEpisode = str_replace("%","",$iplayerEpisode);
	$iplayerEpisode = str_replace("&","",$iplayerEpisode);
	$iplayerEpisode = str_replace("(","",$iplayerEpisode);
	$iplayerEpisode = str_replace(")","",$iplayerEpisode);
	$iplayerEpisode = str_replace("+","",$iplayerEpisode);
	$iplayerEpisode = str_replace(".","",$iplayerEpisode);
	$iplayerEpisode = str_replace(";","",$iplayerEpisode);
	$iplayerEpisode = str_replace("=","",$iplayerEpisode);
	$iplayerEpisode = str_replace("[","",$iplayerEpisode);
	$iplayerEpisode = str_replace("]","",$iplayerEpisode);
	$iplayerEpisode = str_replace("^","",$iplayerEpisode);
	$iplayerEpisode = str_replace("{","",$iplayerEpisode);
	$iplayerEpisode = str_replace("}","",$iplayerEpisode);
	$iplayerEpisode = str_replace("~","",$iplayerEpisode);
	*/
	$iplayerTitle = trim($iplayerEpisode);

	//echo ("\n\nProgram Title: ".$iplayerTitle);
	return $iplayerTitle;
}


//input: string
function deleteFiles($dirName, $PID, $outFileName) {
	shell_exec("DEL /F /S /Q downloads\\*.ts");
}
?>